<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Funnel Chart</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array( 
        array("label"=>"Prospects", "y"=>2130),
        array("label"=>"Inquiries", "y"=>1043),
        array("label"=>"Applicants", "y"=>501),
        array("label"=>"Admits", "y"=>295),
        array("label"=>"Enrolled", "y"=>135)
    )
?>

<script>
    window.onload = function() {
        var chart = new CanvasJS.Chart("chartContainer", {
            theme: "dark2",
            animationEnabled: true,
            title: {
                text: "School Admission Process"
            },
            data: [{
                type: "funnel",
                indexLabel: "{label} - {y}",
                yValueFormatString: "#,##0",
                showInLegend: true,
                legendText: "{label}",
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
    }
</script>

<?php include '../footer.php'; ?>